 
import * as React from "react";

import { Button } from "@/components/ui/form/button";

import { routesConfig } from "@/config/routes";
import {
  Sheet,
  SheetContent,
  SheetTrigger,
} from "@/components/ui/containers/sheet";
import { Logo } from "@/components/ui/logo";
import { Link } from "@tanstack/react-router";
import { ScrollAreaNative } from "../ui/containers/scroll-area.native";

export function MobileNavigation() {
  const [open, setOpen] = React.useState(false);

  return (
    <Sheet open={open} onOpenChange={setOpen}>
      {/** Trigger */}
      <SheetTrigger asChild>
        <Button
          variant="ghost"
          className="mr-2 px-0 text-fluid-base hover:bg-transparent sm:hidden"
        >
          <svg
            strokeWidth="1.5"
            viewBox="0 0 24 24"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            className="h-5 w-5"
          >
            <path
              d="M3 5H11"
              stroke="currentColor"
              strokeWidth="1.5"
              strokeLinecap="round"
              strokeLinejoin="round"
            ></path>
            <path
              d="M3 12H16"
              stroke="currentColor"
              strokeWidth="1.5"
              strokeLinecap="round"
              strokeLinejoin="round"
            ></path>
            <path
              d="M3 19H21"
              stroke="currentColor"
              strokeWidth="1.5"
              strokeLinecap="round"
              strokeLinejoin="round"
            ></path>
          </svg>
          <span className="sr-only">Toggle Menu</span>
        </Button>
      </SheetTrigger>

      {/** Content */}
      <SheetContent side="left" className="flex flex-col pr-0">
        <Logo />

        <ScrollAreaNative className="my-4 h-[calc(100vh-8rem)] pb-10 pl-6">
          <div className="flex flex-col space-y-3">
            {routesConfig.navigation?.map(
              (item) =>
                item.to && (
                  <Link
                    className="text-base text-foreground"
                    key={item.to}
                    to={item.to}
                  >
                    {item.title}
                  </Link>
                ),
            )}
          </div>

          <div className="flex flex-col space-y-2">
            {routesConfig.extended.map((item, index) => (
              <div key={index} className="flex flex-col space-y-3 pt-6">
                <p className="text-accent-foreground text-base font-medium">
                  {item.title}
                </p>
                {item?.items?.length &&
                  item.items.map((item) => (
                    <React.Fragment key={item.to}>
                      {!item.disabled &&
                        (item.to ? (
                          <Link
                            className="text-sm text-foreground"
                            key={item.to}
                            to={item.to}
                          >
                            {item.title}
                            {item.label && (
                              <span
                                className="text-xs text-muted-foreground ml-2 rounded-md bg-[#adfa1d] px-1.5 py-1 leading-none no-underline group-hover:no-underline dark:bg-[#adfa1dab]"
                              >
                                {item.label}
                              </span>
                            )}
                          </Link>
                        ) : (
                          <p className="text-sm text-foreground">
                            {item.title}
                          </p>
                        ))}
                    </React.Fragment>
                  ))}
              </div>
            ))}
          </div>
        </ScrollAreaNative>

        <div className="self-center">
          {/** Extended actions */}
        </div>
      </SheetContent>
    </Sheet>
  );
}
